/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: DriverLayer.h                                                      *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              21/03/2007       1.0                              *
* Carlos Grossy              01/04/2007       1.1                              *
* Carlos Grossy              17/05/2007       1.2                              *
* Carlos Grossy              14/06/2007       1.3                              *
*******************************************************************************/

#ifndef _DRIVERLAYER_H_
#define _DRIVERLAYER_H_

#include "U4ATypes.h"
#include "USBTrans.h"
#include "Log.h"

typedef struct {
    int epnum;
    usbin tdscin;
    usbout tdscout;
} dscEndpoint;

class driverLayer {
    protected:
        int driver;
        log *l;
    public:
        driverLayer();
        virtual ~driverLayer() =0;
        // Inicializacion
        virtual int* getU4ABoards(int&) =0;
        virtual int qtyDsc(int) =0;
        virtual dscEndpoint* getEndpointDsc(int, int) =0;
        // Utilizacion
        virtual int open(int, int, usbin) =0;
        virtual int open(int, int, usbout) =0;
        virtual bool close(int) =0;
        virtual bool sendInt(int, char *, int, int) =0;
        virtual bool sendCtrl(int, char*, int, int) =0;
        virtual bool sendIso(int, char*, int, int) = 0;
        virtual bool sendBulk(int, char*, int, int) =0;
        virtual char* receiveInt(int, int&, bool&, int) =0;
        virtual char* receiveCtrl(int, int&, bool&, int) =0;
        virtual char* receiveIso(int, int&, bool&, int) =0;
        virtual char* receiveBulk(int, int&, bool&, int) =0;
};

#endif
